from machine import Pin,PWM,ADC   
import utime

speed = 1023
left=ADC(Pin(35))
right=ADC(Pin(34))
button = Pin(18,Pin.IN)

def motor(L12,L13,R14,R15):
    PWM(Pin(12)).duty(L12) 
    PWM(Pin(13)).duty(L13) 
    PWM(Pin(14)).duty(R14) 
    PWM(Pin(15)).duty(R15) 

if __name__ == "__main__":
    while button.value() == 1:
        pass
    else:
        while True:
            num_L = left.read_u16()
            num_R = right.read_u16()
            
            if num_L - num_R > 800:
                motor(speed,0,0,speed)
            elif num_R - num_L > 800:
                motor(0,speed,speed,0)
            elif num_R < 2800 and num_L < 2800:
                motor(speed,0,speed,0)
            else:
                motor(0,0,0,0)
